/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm */

'use strict';

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'jquerymobile', 'hbs!modules/staff-user-disclaimer/sud' ],
    function (Portal, Backbone, Marionette, $, jqm, template) {
        return Backbone.Marionette.ItemView.extend({
            initialize: function (options) {
                this.model = options.model;
            },
            id: 'portal-staff-user-disclaimer',
            tagName: 'div',
            attributes: {
                //'class': 'scrollable'
            },
            model: new Backbone.Model(),
            template : template,
            modelEvents: {
                //'sync': 'render',
                'change': 'render'
            },
            events: {
                'tap #cancel-btn': 'redirectToLaunchpad',
                'tap #accept-btn': 'signSud'
            },

            isPhoneGapApp:function(){
                //on phonegapped application, will check for presence of cordova.js
                return false;
            },

            redirectToLaunchpad: function(){
                if(!this.isPhoneGapApp()){
                    window.location = window.location.protocol + "//" + window.location.host + "/launchpad";
                }else{
                    //native launcher code will go here.
                }
            },

            signSud: function() {
                new Backbone.Model({
                    staffUserDisclaimerAccepted: true
                }).save({},{
                        url: Portal.staff().get('staff-user-disclaimer').get('href')
                    });
                Portal.execute("close-modal-dialog");
            }
        });
    });